import os
import zipfile

# BASE DIRECTORY
BASE_DIR = r"C:\Users\myado\Music\cartoons\Cars\PNG"

# SHORTCUT
SHORTCUT_NAME = "vectorseek.url"
SHORTCUT_PATH = os.path.join(BASE_DIR, SHORTCUT_NAME)
VECTORSEEK_URL = "https://vectorseek.com"

# Create shortcut if missing
if not os.path.exists(SHORTCUT_PATH):
    with open(SHORTCUT_PATH, "w") as f:
        f.write("[InternetShortcut]\n")
        f.write(f"URL={VECTORSEEK_URL}\n")
    print("✔ Created vectorseek.url")

# Scan files
all_files = os.listdir(BASE_DIR)

png_files = [f for f in all_files if f.lower().endswith(".png")]
svg_files = [f for f in all_files if f.lower().endswith(".svg")]

# Build lookup tables
png_dict = {
    os.path.splitext(f)[0].replace(" PNG", "").strip(): f
    for f in png_files
}
svg_dict = {
    os.path.splitext(f)[0].replace(" SVG", "").strip(): f
    for f in svg_files
}

# Track files to keep
keep_files = {SHORTCUT_NAME}

# CREATE ZIPs (ONLY when BOTH SVG + PNG exist)
for base_name in svg_dict:
    if base_name not in png_dict:
        continue  # PNG missing → skip

    svg_file = svg_dict[base_name]
    png_file = png_dict[base_name]

    zip_name = base_name + ".zip"
    zip_path = os.path.join(BASE_DIR, zip_name)

    with zipfile.ZipFile(zip_path, "w", zipfile.ZIP_DEFLATED) as zipf:
        zipf.write(os.path.join(BASE_DIR, svg_file), svg_file)
        zipf.write(os.path.join(BASE_DIR, png_file), png_file)
        zipf.write(SHORTCUT_PATH, SHORTCUT_NAME)

    keep_files.add(zip_name)
    keep_files.add(png_file)

    print(f"✔ Created ZIP (PNG + SVG + URL): {zip_name}")

# CLEANUP: delete everything else
for file in all_files:
    if file not in keep_files:
        try:
            os.remove(os.path.join(BASE_DIR, file))
            print(f"🗑 Deleted: {file}")
        except Exception as e:
            print(f"⚠ Could not delete {file}: {e}")

print("✅ DONE — Only ZIPs + matching PNGs + shortcut remain")
